----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    09:37:08 03/21/2012 
-- Design Name: 
-- Module Name:    synchrovertihori - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity vgaControler is
	port (clk : in std_logic;
			hSync, vSync : out std_logic;
			videoOn : out std_logic;
			column : out std_logic_vector (7 downto 0);
			row : out std_logic_vector (6 downto 0));
end vgaControler;

architecture Behavioral of vgaControler is
signal hCounter : std_logic_vector (9 downto 0) := (others=>'0');
signal vCounter : std_logic_vector (9 downto 0) := (others=>'0');

	begin
		process (clk)
		begin
			if (clk'event and clk='1') then
				if hCounter = 799 then
					hCounter <= (others=>'0');
				else hCounter <= hCounter + '1';
				end if;			
			end if;
		end process;

	hSync <= '0' when (hCounter > 655) and (hCounter < 751) else '1';
	vSync <= '0' when (vCounter > 489) and (vCounter < 492) else '1';

	process (clk)
		begin
			if (clk'event and clk='1') then
				if (hCounter = 799 and vCounter=520) then
					vCounter <= (others=>'0');
				elsif (hCounter = 799) then
					vCounter <= vCounter + '1';
				end if;			
			end if;
	end process;
		
	videoOn <= '1' when hCounter<640 and vCounter < 480 else '0';

	column <= hCounter (9 downto 2);
	row <= vCounter (8 downto 2);

end Behavioral;