library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity rotaryXilinx is
    Port ( clk : in  STD_LOGIC;
           rotary_b_in : in  STD_LOGIC;
           rotary_a_in : in  STD_LOGIC;
           enableUP : out STD_LOGIC;
           enableDOWN : out  STD_LOGIC
			  );
end rotaryXilinx;

architecture Behavioral of rotaryXilinx is
signal rotary_event, rotary_left, rotary_q1, rotary_q2, delay_rotary_q1, delay_rotary_q2 : std_logic:='0'; 
signal rotary_in : std_logic_vector (1 downto 0) := "00";

begin

	rotary_filter: process(clk)
		begin
		if clk'event and clk='1' then
			rotary_in <= not (rotary_b_in & rotary_a_in);

			case rotary_in is
					when "00" => 	rotary_q1 <= '0';
										rotary_q2 <= rotary_q2;
					when "01" => 	rotary_q1 <= rotary_q1;
										rotary_q2 <= '0';
					when "10" => 	rotary_q1 <= rotary_q1;
										rotary_q2 <= '1';
					when "11" => 	rotary_q1 <= '1';
										rotary_q2 <= rotary_q2;
					when others => rotary_q1 <= rotary_q1;
										rotary_q2 <= rotary_q2;
			end case;
		end if;
	end process rotary_filter;
	
direction: process(clk)
	begin
		if clk'event and clk='1' then
			delay_rotary_q1 <= rotary_q1;
			if rotary_q1='1' and delay_rotary_q1='0' then
				rotary_event <= '1';
				rotary_left <= rotary_q2;
			else
				rotary_event <= '0';
				rotary_left <= rotary_left;
	end if;
	end if;
end process direction;

	enableUP<='1' when rotary_event='1' and rotary_left ='1' else '0';
	enableDOWN<='1' when rotary_event='1' and rotary_left ='0' else '0';

end Behavioral;