--------------------------------------------------------------------------------
-- Copyright (c) 1995-2007 Xilinx, Inc.  All rights reserved.
--------------------------------------------------------------------------------
--   ____  ____ 
--  /   /\/   / 
-- /___/  \  /    Vendor: Xilinx 
-- \   \   \/     Version : 9.2.04i
--  \   \         Application : sch2vhdl
--  /   /         Filename : global.vhf
-- /___/   /\     Timestamp : 05/24/2012 14:07:26
-- \   \  /  \ 
--  \___\/\___\ 
--
--Command: C:\PROGRAMS\Xilinx92i\bin\nt\sch2vhdl.exe -intstyle ise -family spartan3e -flat -suppress -w U:/Miniprojetnum/tele/global.sch global.vhf
--Design Name: global
--Device: spartan3e
--Purpose:
--    This vhdl netlist is translated from an ECS schematic. It can be 
--    synthesis and simulted, but it should not be modified. 
--

library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity global is
   port ( Ac          : in    std_logic; 
          Ar          : in    std_logic; 
          Bc          : in    std_logic; 
          Br          : in    std_logic; 
          clk         : in    std_logic; 
          colorchoice : in    std_logic_vector (7 downto 0); 
          Reset       : in    std_logic; 
          saut        : in    std_logic; 
          an          : out   std_logic_vector (3 downto 0); 
          hSync       : out   std_logic; 
          rgb         : out   std_logic_vector (7 downto 0); 
          seg         : out   std_logic_vector (6 downto 0); 
          vSync       : out   std_logic);
end global;

architecture BEHAVIORAL of global is
   attribute BOX_TYPE   : string ;
   signal XLXN_2      : std_logic_vector (7 downto 0);
   signal XLXN_3      : std_logic_vector (6 downto 0);
   signal XLXN_11     : std_logic;
   signal XLXN_19     : std_logic;
   signal XLXN_20     : std_logic;
   signal XLXN_38     : std_logic;
   signal XLXN_52     : std_logic_vector (0 downto 0);
   signal XLXN_70     : std_logic;
   component premiertp
      port ( clk            : in    std_logic; 
             colorchoice_in : in    std_logic_vector (7 downto 0); 
             row_in         : in    std_logic_vector (6 downto 0); 
             column_in      : in    std_logic_vector (7 downto 0); 
             dinb_in        : in    std_logic_vector (0 downto 0); 
             web_in         : in    std_logic; 
             rgb            : out   std_logic_vector (7 downto 0); 
             hSync          : out   std_logic; 
             vSync          : out   std_logic; 
             reset          : in    std_logic);
   end component;
   
   component compteur_sature_column
      port ( clk          : in    std_logic; 
             enableCUP    : in    std_logic; 
             enableCDOWN  : in    std_logic; 
             resetC       : in    std_logic; 
             finComptageC : out   std_logic; 
             column       : out   std_logic_vector (7 downto 0));
   end component;
   
   component compteur_sature_row
      port ( clk          : in    std_logic; 
             enableRUP    : in    std_logic; 
             enableRDOWN  : in    std_logic; 
             resetR       : in    std_logic; 
             finComptageR : out   std_logic; 
             row          : out   std_logic_vector (6 downto 0));
   end component;
   
   component VCC
      port ( P : out   std_logic);
   end component;
   attribute BOX_TYPE of VCC : component is "BLACK_BOX";
   
   component disp7seg
      port ( clk    : in    std_logic; 
             seg    : out   std_logic_vector (6 downto 0); 
             anode  : out   std_logic_vector (3 downto 0); 
             row    : in    std_logic_vector (6 downto 0); 
             column : in    std_logic_vector (7 downto 0));
   end component;
   
   component rotaryXilinx
      port ( clk         : in    std_logic; 
             rotary_b_in : in    std_logic; 
             rotary_a_in : in    std_logic; 
             enableUP    : out   std_logic; 
             enableDOWN  : out   std_logic);
   end component;
   
   component sequenceur_saut
      port ( appuyer : in    std_logic; 
             clk     : in    std_logic; 
             web_in  : out   std_logic);
   end component;
   
begin
   XLXI_4 : premiertp
      port map (clk=>clk,
                colorchoice_in(7 downto 0)=>colorchoice(7 downto 0),
                column_in(7 downto 0)=>XLXN_2(7 downto 0),
                dinb_in(0)=>XLXN_52(0),
                reset=>Reset,
                row_in(6 downto 0)=>XLXN_3(6 downto 0),
                web_in=>XLXN_70,
                hSync=>hSync,
                rgb(7 downto 0)=>rgb(7 downto 0),
                vSync=>vSync);
   
   XLXI_6 : compteur_sature_column
      port map (clk=>clk,
                enableCDOWN=>XLXN_20,
                enableCUP=>XLXN_19,
                resetC=>Reset,
                column(7 downto 0)=>XLXN_2(7 downto 0),
                finComptageC=>open);
   
   XLXI_7 : compteur_sature_row
      port map (clk=>clk,
                enableRDOWN=>XLXN_38,
                enableRUP=>XLXN_11,
                resetR=>Reset,
                finComptageR=>open,
                row(6 downto 0)=>XLXN_3(6 downto 0));
   
   XLXI_15 : VCC
      port map (P=>XLXN_52(0));
   
   XLXI_17 : disp7seg
      port map (clk=>clk,
                column(7 downto 0)=>XLXN_2(7 downto 0),
                row(6 downto 0)=>XLXN_3(6 downto 0),
                anode(3 downto 0)=>an(3 downto 0),
                seg(6 downto 0)=>seg(6 downto 0));
   
   XLXI_18 : rotaryXilinx
      port map (clk=>clk,
                rotary_a_in=>Br,
                rotary_b_in=>Ar,
                enableDOWN=>XLXN_38,
                enableUP=>XLXN_11);
   
   XLXI_19 : rotaryXilinx
      port map (clk=>clk,
                rotary_a_in=>Bc,
                rotary_b_in=>Ac,
                enableDOWN=>XLXN_20,
                enableUP=>XLXN_19);
   
   XLXI_23 : sequenceur_saut
      port map (appuyer=>saut,
                clk=>clk,
                web_in=>XLXN_70);
   
end BEHAVIORAL;


