----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    20:25:47 11/07/2011 
-- Design Name: 
-- Module Name:    disp7seg - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity disp7seg is
    Port ( 	clk : in std_logic;
				row : in  STD_LOGIC_VECTOR (6 downto 0);
				column : in std_logic_vector (7 downto 0);
				seg : out  STD_LOGIC_VECTOR (6 downto 0);
				anode : out  STD_LOGIC_VECTOR (3 downto 0));
end disp7seg;

architecture Behavioral of disp7seg is
signal data_in : std_logic_vector (15 downto 0);
signal comptage : std_logic_vector (18 downto 0) :=(others=>'0');
alias value is comptage (18 downto 17);
signal multiplex : std_logic_vector (3 downto 0) :=x"0";
type tv is array (0 to 15) of std_logic_vector (6 downto 0);
constant table : tv := (	"1000000", "1111001",
									"0100100", "0110000",
									"0011001", "0010010",
									"0000010", "1111000",
									"0000000", "0010000",
									"0001000", "0000011",
									"1000110", "0100001",
									"0000110", "0001110");
begin

	data_in <= '0' & row & column;
	
	process (clk)
	begin
		if (clk'event and clk='1')
		then
			comptage <= comptage + '1';
		end if;
	end process;

	anode <= "1110" when value="00" else "1101" when value="01" else "1011" when value="10" else "0111";
	
	multiplex <= data_in (conv_integer(value)*4 + 3 downto conv_integer(value)*4);
	
	seg <= table (conv_integer(multiplex)); 
	
end Behavioral;

