----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    10:55:50 04/04/2012 
-- Design Name: 
-- Module Name:    Sequenceur - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Sequenceur is
    Port ( clk : in  STD_LOGIC;
			  A : in  STD_LOGIC;
           B : in  STD_LOGIC;
           EnableRUP : out  STD_LOGIC;
           EnableRDOWN : out  STD_LOGIC);
end Sequenceur;

architecture Behavioral of Sequenceur is
type etat is (S1,S2,S3,S4,Comptage,Decomptage);
signal present,futur : etat;
begin
		process(clk)
		begin
				if(clk'event and clk='1') then 
					present<=futur;
				end if;
		end process;
		
		process(present,A,B)
		begin
		case present is 
				when S1 => 
					if A='1' and B='0' 
						then futur <= S2;
						elsif A&B="01"  then futur <= S4;
						else futur <= S1;
					end if;
					
				when S2 =>
					if A='1' and B='1' 
						then futur <= S1;
						elsif A&B="00"  then futur <= Comptage;
						else futur <= S2;
					end if;
					
				
				when S3 =>
					if A='1' and B='0' 
						then futur <= S2;
						elsif A&B="01"  then futur <= S4;
						else futur <= S3;
					end if;
					
				
				when S4 =>
					if A='1' and B='1' 
						then futur <= S1;
						elsif A&B="00"  then futur <= Decomptage;
						else futur <= S4;
					end if;
							
				
				when Comptage =>
					futur <= S3;
				
				when Decomptage =>
					futur <= S3;
		
		
		end case;
		end process;
		
		EnableRUP <= '1' when (present = Comptage) else '0';
		EnableRDOWN <= '1' when (present = Decomptage) else '0';
		
end Behavioral;

