/**
 *@file uart.c
 *
 *@brief Fichier contenant les fonctions lies UART
 *@details
 * Vous trouverez ici les fonctions UART0_init(), UART0_read() et UART0_send().
 *@warning Les fonctions UART0_read() et UART0_send() ne doivent tre appeles que dans les interruptions.
 *@author Bayoumi Chamaa et Comte-Gaz Quentin
 *@date Novembre 2013
 *@version 1.0
 */
#include "uart.h"
#include <cdefBF534.h>

unsigned char buffer[100]; /*!< @brief Buffer contenant la trame GPS en cours de rception via l'UART0*/

/**
 *@fn void UART0_init(void)
 *@brief Initialisation de l'UART 0 ainsi que le DMA (pour le gps)
 *@details
 * Cette fonction initialise l'UART 0 sur les pins F0 et F1 avec un baudrate de 4800bits/sec, 1 bit de stop ainsi que 8 bits de donnes.
 * Nous utilisons un DMA pour l'envoie de trame.
 * Pour cela, nous ions l'UART 0 TX au DMA 9 en le configurant correctement.
 *@warning Cette fonction doit tre appele avant d'utiliser les autres fonctions lies  l'UART 0.
 */
void UART0_init(void){
*pPORTF_FER|=0x0003; //Activer l'UART (brancher les pins F0 et F1 au TX et RX).
*pUART0_GCTL=0x01; //Activer la clk sur l'UART0
*pUART0_LCR=0x83; // Acces baudrate, parit, 1 bit stop, 8bits data

*pUART0_DLH=0x05; // baudrate de 4800 bits/sec (<=>1302= 0x516)
*pUART0_DLL=0x16;
        
*pUART0_LCR =0x03; //Masquage pour mettre le MSB  0 (dsactiver accs au baudrate)

/*----DMA-----*///pour le moment : UART tx

*pDMA9_X_MODIFY=1; //On envoie des octets
*pDMA9_X_COUNT=0; //Ce registre est galement dit dans UART0_IRQ
*pDMA9_START_ADDR=(void *)(buffer+1);
*pDMA9_PERIPHERAL_MAP=0x9000; //Lier UART0 tx au dma 9
*pDMA9_CONFIG=0x0080; //8bits,DI_EN,/DI_SEL,stop after send

}

/**
 *@fn char UART0_read(void)
 *@brief Lecture d'un octet via l'UART 0 (gps) sans attente
 *@details
 * Lecture d'un octet via l'UART 0 (gps) sans attente (cela implique que l'on doit tre sr qu'il y a un lment)
 * Pour information : Nous utilisons cette fonction dans les interruptions uniquement quand on est sr qu'un lment est bien prsent.
 * Nous avons prferer ne pas mettre de "while()" puisque nous utilisons cette fonction dans les interruptions.
 * Pour cela, nous ions l'UART 0 TX au DMA 9 en le configurant correctement.
 *@warning Cette fonction doit tre appele aprs UART0_init().
 *@return Octet reu via l'UART 0 (GPS).
 */
 char UART0_read(void){  
    //while(1){   //While --> Avec attente    
     if((*pUART0_LSR)&0x01==0x01)
       return (char)(*pUART0_RBR);   
     else return 0; 
    //}    
}

/**
 *@fn void UART0_send(char c)
 *@brief Ecriture d'un octet via l'UART 0 (Hyperterminal du PC)
 *@warning Cette fonction doit tre appele aprs UART0_init().
 *@param c Octet  envoyer via l'UART 0 (Hyperterminal du PC).
 */
void UART0_send(char c){
    *pUART0_THR=c;
}
