/**
 *@file main.c
 *
 *@brief Fichier contenant notre fonction principale
 *@details
 * Vous trouverez ici la fonction main() ("premire" fonction  se lancer)
 *@author Bayoumi Chamaa et Comte-Gaz Quentin
 *@date Novembre 2013
 *@version 1.0
 */

/*
Etapes :
	1- Rception GPS par boucle d'attente (V)
	2- Rception GPS par interruption (V)
	3- Mise dans un tableau de caractres puis envoie sur hyperterminal via interruptions UART (V)
	4- Mise dans un tableau de caractres puis envoie sur hyperterminal via DMA (V)
	5- Envoie sur bus CAN par boucle d'attente (8 octets) (V)
	6- Gestion bus CAN par interruption et envoie via interruption UART + codage d'optimisation (V)
	7- Gestion bus CAN par interruption et envoie via interruption CAN RX (V)
	8- Optimisation du code (interruption) + commentaires (V)
	Note : Problme li  la dure de l'interruption uart0 rx rsolu
*/


#include "uart.h"
#include "ISR.h"
#include "CAN.h"
#include <cdefBF534.h>

/**
 *@fn void main(void)
 *@brief 
 * Fonction main classique qui va initialiser l'UART, le bus CAN ainsi que toutes les interruptions associes.
 * Remarquons que l'on ne sort jamais de cette fonction (pas d'arret du programme) afin que les interruptions puissent avoir lieu.
 */
void main(void){
  uart0_init();
  Init_Interrupts();
  init_CAN();

  while(1);
}

/*
 //Premier test :
 int i;
Rception GPS par boucle d'attente :
  char car;
   if(i>=100) 
  	i=0;
  car=uart0_read();
  uart0_send(car);
  i++;    
*/


/*! @mainpage Envoie des coordonnes GPS et de l'heure via bus CAN
 *
 * @section intro_sec Introduction
 *
 * Le code prsent a t cre par Bayoumi Chamaa et Comte-Gaz Quentin.<BR>
 * Carte utilise : Blackfin 537<BR>
 * <BR>
 * Le projet consistait  :<BR>
 * - rcuprer des trames via UART provenant d'un GPS<BR>
 * - traiter les trames reues afin de ne garder que celles contenant les coordonnes GPS ainsi que l'heure<BR>
 * - envoyer les trames valides via UART (DMA)<BR>
 * - envoyer les coordonnes GPS et/ou l'heure via bus CAN si une demande est effectue (respectivement via les id 21 et 20)<BR>
 *<BR>
 *<BR>
 *Voici les diffrentes tapes effectues lors de notre projet :<BR>
 *  	1- Rception GPS par boucle d'attente (V)<BR>
 *		2- Rception GPS par interruption (V)<BR>
 *		3- Mise dans un tableau de caractres puis envoie sur hyperterminal via interruptions UART (V)<BR>
 *		4- Mise dans un tableau de caractres puis envoie sur hyperterminal via DMA (V)<BR>
 *		5- Envoie sur bus CAN par boucle d'attente (8 octets) (V)<BR>
 *		6- Gestion bus CAN par interruption et envoie via interruption UART + codage d'optimisation (V)<BR>
 *		7- Gestion bus CAN par interruption et envoie via interruption CAN RX (V)<BR>
 *		8- Optimisation du code (interruption) (V)<BR>
 *		9- Commentaires Doxygen/JavaDoc(V)<BR>
 *<BR>
 *
 * \section uart UART-DMA (GPS)
 * Voici les diffrentes fonctions/interruptions lies  l'UART-DMA :<BR>
 * <BR>
 * UART0_init(void) (Initialisation de l'UART 0 ainsi que le DMA (pour le gps))<BR>
 * UART0_read(void) (Lecture d'un octet via l'UART 0 (gps) sans attente)<BR>
 * UART0_send(char c) (Ecriture d'un octet via l'UART 0 (Hyperterminal du PC))<BR>
 * EX_INTERRUPT_HANDLER(Uart0_ISR) (Interruption de reception d'un char via l'UART 0 (GPS))<BR>
 * EX_INTERRUPT_HANDLER(Uart0_tx_DMA_ISR) (Interruption de transmission d'une trame via l'UART0-DMA9 (Hyperterminal du PC))<BR>
 * Init_Interrupts(void) (Fonction d'initialisation des interruptions CAN et UART0-DMA9 ainsi que leurs priorits associes)<BR>
 *<BR>
 *
 * \section can Bus CAN
 * Voici les diffrentes fonctions/interruptions lies au bus CAN :<BR>
 * <BR>
 * init_CAN(void) (Initialisation du bus CAN ainsi que des mailboxes  utiliser)<BR>
 * preparation_mailbox(unsigned char *data, int taille_data, int mbID) (Prparation des mailbox d'envoie (uniquement l'heure et la position > mailboxes 20 et 21))<BR>
 * EX_INTERRUPT_HANDLER(Can_tx_ISR) (Interruption de fin de transmission d'une trame CAN via le bus CAN)<BR>
 * EX_INTERRUPT_HANDLER(Can_rx_ISR) (Interruption de reception d'une demande CAN via le bus CAN)<BR>
 * Init_Interrupts(void) (Fonction d'initialisation des interruptions CAN et UART0-DMA9 ainsi que leurs priorits associes)<BR>
 *<BR>
 *
 * \section var_globales Variables globales
 * Voici les diffrentes variables globales utilises :<BR>
 *<BR>
 *  buffer [100] (buffer pour l'UART)<BR>
 *  buffer_can[100] (buffer pour le CAN)<BR>
 *  buffer_can_ready (protection pour viter d'envoyer une trame via CAN alors qu'elle est en cours d'dition via UART0)<BR>
 *  flag_fin_can (flag de fin d'envoie CAN)<BR>
 *  flag_irq_tx (flag de fin d'envoie UART0)<BR>
 *  position_buffer (position du buffer de l'UART)<BR>
 * <BR>
 * Pour plus d'informations sur ces variables, je vous conseille de consulter la page suivante :<BR>
 * <a href="globals.html">Globals.html</a><BR>
 * \section autre Pour aller plus loin
 * Notre programme est fonctionnel. Cependant, pour avoir un projet ne contenant aucune faille, on pourrait utiliser un RTOS afin de protger les ressources critiques (buffer_can par exemple).<BR>
 * Voici une liste des RTOS compatibles avec la carte Blackfin 537 :<BR>
 * <a href="http://en.wikipedia.org/wiki/Blackfin#Supported_operating_systems.2C_RTOSs_and_kernels">http://en.wikipedia.org/wiki/Blackfin#Supported_operating_systems.2C_RTOSs_and_kernels</a><BR>
 *
 *
 *<BR>
 */
